;;
;; Virtual Disk Drive Project - August 9, 2001 - EJR (in Hawaii)
;;;			- rewritten extensively in Sep 2003 for
;;;			  DD mostly.
;;

#include "main.h"
#include "vd.h"
#include "utility.h"
#include "serbyte.h"
#include "serbyte.mac"
#include "headmove.mac"
#include "disk.h"
#include "sersector.h"
#include "write.mac"
#include "apple.h"
		
PROG1	CODE
	
	global	SerTrack
	global	SerTrackSecDone
	global	SerTrackFinal
	
;;;*******************************************************************
;;; NAME:	SerTrack()
;;;
;;; DESCR:	Sends out a track chock full of sectors.  A sector
;;;		can be SD, DD, of blank.  Note that "blank" is non-
;;;		sector that is simply skipped.  This is used when
;;;		there is a weird track with a missing sector(s).
;;;
;;; ARGS:	
;;;
;;; RETURNS:	
;;;
;;; NOTES:	- memory alignment assumes that each sector consumes
;;;		  the same number of bytes from the header (this includes
;;;		  blank sectors)...so the only variable is the number
;;;		  of sectors.
;;;*******************************************************************
SerTrack:
	
	;; Check to see if the track 0 line should be brought up or not
	;; the way this is written, the line WON'T go down between tracks.
	;; It will only go down when a track is being generated that isn't
	;; the zero track.
	
		movf		CURTRACK	; () just checking for track 0
		skpnz				; ()
		Raise		TRACK0		; () bring up track 0 line

		HeadCheckPage1			; () these are sprinkled around
	
		movf		CURTRACK	; () just checking for track 0
		skpz				; ()
		Lower		TRACK0		; () bring down track 0 line

	;; Note that the track zero line DOES come down if the drive is
	;; de-selected.  (see main.asm)

		MemReadMode			; () prepare to read memory
		MemAddrSet			; () set base to current track start (CURBASE)

	;; This variable is used to auto-increment memory in the blank sectors
	;; and in the trailers.  Just be sure nothing happens 'till we're ready.
	
		clrf		INCVAR

	;; note that upon entry to SerTrackRpt, the base is set to the current
	;; track start either explicitly (above) or because of the last sector

		HeadCheckPage1			; () these are sprinkled around
	
SerTrackRpt:

		clrf		SECCOUNT	; () prepare current sector number

		Raise		INDEX_HOLE	; (-4) bring up the index hole line

		HeadCheckPage1			; () these are sprinkled around

SerTrackSec:	;; assumes that the memory is set to start

		MemReadByte			; (-3) get the sector format into W
		movwf		WORK1		; (-2)
		MemLowInc			; (-1)

	;; Note that we ran out of space in code page 1 when implementing DDSector
	;;   so just to plan ahead, all sector generation code will be put into
	;;   the second page.  This includes byte generation etc.  Each of these
	;;   routines return the PAGESEL back to page 1 so they can do a goto
	;;   back to SerTrackSecDone
	
		HeadCheckPage1			; () these are sprinkled around

		PAGESEL		DDSector
	
		btfsc		WORK1,0		; (1) 0x01 --> DD sector
		goto		DDSector	; (2) needs to be -8, off by 10 (1/2 of a DD bit cell)
		btfsc		WORK1,1		; (3) 0x02 --> SD sector
		goto		SDSector	; (4) needs to be -8, off by 12 (1/4 of a SD bit cell)
		btfsc		WORK1,2		; (5) 0x04 --> DD blank sector
		goto		DDBlankSector	; (6)
		btfsc		WORK1,3		; (7) 0x08 --> SD blank sector
		goto		SDBlankSector	; (8) 
		btfsc		WORK1,4		; (7) 0x10 --> Apple 2 - GCR6x2
		goto		GCR6x2Sector	; (8) 
		btfsc		WORK1,5		; (7) 0x20 --> Apple 2 - GCR5x3
		goto		GCR5x3Sector	; (8) 
		btfsc		WORK1,6		; (7) 0x40 --> Apple 2 - NIB (raw)
		goto		NIBSector	; (8) 
		goto		H17Sector	; (9) 0x00 (or anything else) --> H17 sector
	
SerTrackSecDone:				; (-9)
	
	;; turns off checks for the WRITE_GATE
	
		WriteDisable
	
	;; at this point SECCOUNT is set to the NEXT track, so if it equals SECTORS
	;; then we are done

		movf		SECTORS,W	; (-8) done with track yet?
		subwf		SECCOUNT,W	; (-7)
		skpz				; (-6)
		goto		SerTrackSec	; (-5)

SerTrackDone:

	;; some formats require a trailer...often these formats also require the
	;; alignment of memory.  That is, the header didn't require all 256 bytes
	;; and memory needs to be incremented so that the next generation of this
	;; track starts at zero.

		MemReadByte			; () get the trailer format into W
		movwf		WORK1
		MemLowInc			; ()

		HeadCheckPage1
		PAGESEL		DDSector
	
		btfsc		WORK1,0		; (5) 
		goto		DDTrailer	; (-8) 0x01 --> DD trailer
		btfsc		WORK1,1
		goto		SDTrailer	; (-8) 0x02 --> SD trailer
		btfsc		WORK1,2
		goto		GCRTrailer	; (-8) 0x04 --> Apple 2 - GCR Trailer
						; (-8) 0x00 (or anything else) --> NO trailer

SerTrackFinal:					; (-13 or -7)
	
		DiskLineMap			; () prepare for DiskTable call
		call		DiskTable	; () W has selected disk
		xorwf		CURDISK,W	; () the same disk?
	
		HeadCheckPage1

		skpnz				; () if zero, stay on track
		goto		SerTrackRpt	; ()
	
		return				; () otherwise return
		
;;; =======================================================================
;;; =======================================================================

	END
